clear all
close all

%%%%%%%% importing 2D data and selecting a column for 1D tests %%%%%%%%
file = fopen('fidmo.ft2'); % 2D data: F1 - frequency domain, F2 - time domain
fid = fread(file, 'single');
fid = fid(513:end); % removing header
fid2d = reshape(fid, 512, 1442*2);
fid2d = fid2d(:, 1:2:end) + 1i*fid2d(:, 2:2:end); % making complex 2D signal

col = 935; % selecting a column
f = fid2d(:, col); % 1D signal for testing
n = length(f); % full grid size

ppm = linspace(-11.227, 188.757, n);

%%%%%%%% phasing %%%%%%%%
phase = 110;
f = f*exp(1i*phase*pi/180);

%%%%%%%% generating random NUS schedule %%%%%%%%
sch = sort(randperm(n, 64));
sch(1) = 1;
f_s = f(sch);
f_expanded = zeros(size(f));
f_expanded(sch) = f(sch);

%%%%%%%% estimating noise norm %%%%%%%%
spec = fft(f);
noisy_region = spec(1:150);
scaling = norm(spec)/norm(f);
res = (norm(noisy_region)/(length(noisy_region)*scaling))*length(sch);

%%%%%%%% OMP %%%%%%%%
options.res = res*5;
f_omp = omp(f_s, sch, length(f), options); % reconstructed spectrum

figure; 
plot(ppm, real(spec), 'black'); % original spectrum
hold on;  plot(ppm, real(f_omp), 'r'); % reconstructed spectrum 
title('OMP')
xlim([-11.227, 188.757])

%%%%%%%% IST-D %%%%%%%%
clear options
options.threshold = 0.8;
options.res = res*5;
f_ist_d = ist_d(f_s, sch, length(f), options); % reconstructed spectrum

figure; 
plot(ppm, real(spec), 'black'); % original spectrum
hold on;  plot(ppm, real(f_ist_d), 'r'); % reconstructed spectrum 
title('IST-D')
xlim([-11.227, 188.757])

%%%%%%%% IST-S %%%%%%%%
clear options
options.threshold = 0.999;
f_ist_s = ist_s(f_s, sch, length(f), options); % reconstructed spectrum

figure; 
plot(ppm, real(spec), 'black'); % original spectrum
hold on;  plot(ppm, real(f_ist_s), 'r'); % reconstructed spectrum 
title('IST-S') 
xlim([-11.227, 188.757])

%%%%%%%% IRLS %%%%%%%%
clear options
options.eps = 1e4;
options.lambda = 5e3;
options.norm = 0.5;
f_irls = irls(f_s, sch, length(f), options); % reconstructed spectrum

figure; 
plot(ppm, real(spec), 'black'); % original spectrum
hold on;  plot(ppm, real(f_irls), 'r'); % reconstructed spectrum 
title('IRLS') 
xlim([-11.227, 188.757])

%%%%%%%% Low rank %%%%%%%%
clear options
options.lambda = 20;
f_lr = low_rank(f_s, sch, length(f), options); % reconstructed FID

figure; 
plot(ppm, real(spec), 'black'); % original spectrum
hold on;  plot(ppm, real(fft(f_lr)), 'r'); % reconstructed spectrum 
title('Low rank') 
xlim([-11.227, 188.757])
